/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ColorPickerRobot
extends JFrame
implements MouseListener,
MouseMotionListener {
    JPanel image_panel;
    Dimension screen_size = Toolkit.getDefaultToolkit().getScreenSize();
    JComponent comp = null;
    Image background_image = null;
    Robot robot;
    JLabel label;

    public ColorPickerRobot(JComponent comp) {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.comp = comp;
        this.setUndecorated(true);
        this.setSize(this.screen_size.width, this.screen_size.height);
        this.image_panel = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(ColorPickerRobot.this.background_image, 0, 0, null);
            }
        };
        this.image_panel.setPreferredSize(this.screen_size);
        this.image_panel.setLayout(null);
        this.getContentPane().add(this.image_panel);
        this.label = new JLabel("Selected Color");
        this.label.setOpaque(true);
        this.label.setSize(100, 100);
        this.image_panel.add(this.label);
        this.label.setLocation((int)this.screen_size.getWidth() / 2 - 50, (int)this.screen_size.getHeight() / 2 - 50);
    }

    @Override
    public void show() {
        try {
            Rectangle rect = new Rectangle(0, 0, (int)this.screen_size.getWidth(), (int)this.screen_size.getHeight());
            this.robot = new Robot();
            this.background_image = this.robot.createScreenCapture(rect);
            super.show();
        }
        catch (AWTException ex) {
            System.out.println("exception creating screenshot:");
            ex.printStackTrace();
        }
    }

    public void setSelectedColor(Color color) {
        this.comp.setBackground(color);
        this.label.setBackground(color);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.setSelectedColor(this.robot.getPixelColor(evt.getX(), evt.getY()));
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        this.setSelectedColor(this.robot.getPixelColor(evt.getX(), evt.getY()));
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.setSelectedColor(this.robot.getPixelColor(evt.getX(), evt.getY()));
        this.setVisible(false);
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Color Chooser Hack");
        final JButton button = new JButton("Click to choose a color");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorPickerRobot frame = new ColorPickerRobot(button);
                ((Window)frame).show();
            }
        });
        frame.getContentPane().add(button);
        frame.pack();
        frame.setVisible(true);
    }
}

